/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "..\x86emu.h"

int GetProcAddress_emu(Thread* thread,dword* Args){
    char* str=0;
    try{
        str=(char*)thread->mem->read_virtual_mem(Args[1]);
        
    //invalid pointer return 0            
    }catch(...){
                return 0;
    };
    //if valid don't return zero but return any address
    if (Args[0]==0)return 0xBBBBBBBB;
    dword dllhandle=(dword)thread->mem->read_virtual_mem(Args[0]);
    dword ptr=thread->process->getsystem()->GetAPI(str,dllhandle);
    ptr=thread->mem->get_virtual_pointer(ptr);
    if (ptr==0)return 0xBBBBBBBB;
    free(Args);
    return ptr;
};

int GetModuleHandleA_emu(Thread* thread,dword* Args){
    if (Args[0]==0)return thread->process->GetImagebase();
    char* str=(char*)thread->mem->read_virtual_mem(Args[0]);
    dword ptr=thread->process->getsystem()->GetDllBase(str);
    ptr=thread->mem->get_virtual_pointer(ptr);
    return ptr;
};

int LoadLibraryA_emu(Thread* thread,dword* Args){
    char* str=(char*)thread->mem->read_virtual_mem(Args[0]);
    dword ptr=thread->process->getsystem()->GetDllBase(str);
    ptr=thread->mem->get_virtual_pointer(ptr);
    if(ptr==0){ptr=thread->process->getsystem()->DLLs[0].vAddr;}
    return ptr;
};
int VirtualAlloc_emu(Thread* thread,dword* Args){
    bool x=false;
    dword ptr=(dword)malloc(Args[1]);             //the size
    dword addr=Args[0];                    //the address
    try{
        thread->mem->read_virtual_mem(addr);
        x=true;                             //the pointer allready allocated 
    }catch(...){
                x=false;
    }
    if (addr==0 || x){
        addr=thread->mem->CommittedPages;
        thread->mem->CommittedPages+=0x10000+(Args[1]& 0xffff0000);
    };
    thread->mem->add_pointer(ptr,addr,Args[1]);
    return addr;
};
int VirtualFree_emu(Thread* thread,dword* Args){
    thread->mem->delete_pointer(Args[0]);
    return 1;
};
int VirtualProtect_emu(Thread* thread,dword* Args){
    dword vptr=Args[0];
    dword rptr=(dword)thread->mem->read_virtual_mem(Args[0]);
    dword size=Args[1];
    thread->mem->add_pointer(rptr,vptr,size,MEM_VIRTUALPROTECT);  
    return 1;
};
